# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 5
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR5_strategy.txt
# LLM Suggested Fallback: C

def sunshine_serpent(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    
    if always_c or always_d:
        return "D"
    
    if current_round <= 3:
        return "C"
    elif current_round <= 7:
        if "D" in opp_history:
            return opp_history[-1]
        else:
            return "C"
    else:
        if current_round == 8:
            return "D"
        else:
            if len(opp_history) > 0:
                return opp_history[-1]
            else:
                return "C"